/*
	MITEC MP-85 Emulator 'eMP-85'

	Author : Takeda.Toshiya
	Date   : 2021.01.19-

	[ display ]
*/

#include "display.h"

static const int led_pattern[LED_SIZE_Y][LED_SIZE_X] = {
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,2,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,5,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
};

void DISPLAY::initialize()
{
	memset(led, 0, sizeof(led));
	sel = 0;
}

void DISPLAY::write_signal(int id, uint32_t data, uint32_t mask)
{
	if(id == SIG_DISPLAY_SEL) {
		sel = data & mask;
	} else if(id == SIG_DISPLAY_DISP) {
		led[sel & 15] = data & mask;
	}
}

void DISPLAY::draw_screen()
{
	// draw 7-seg LEDs
	scrntype_t col[10];
	scrntype_t color_on  = RGB_COLOR(255, 8, 72);
	scrntype_t color_off = RGB_COLOR(111, 33, 33);
	col[0] = RGB_COLOR(96, 53, 53);
	col[9] = color_off;
	
	for(int i = 0; i < 6; i++) {
		uint8_t pat = ~led[5 - i];
		col[1] = pat & 0x01 ? color_on : color_off;
		col[2] = pat & 0x02 ? color_on : color_off;
		col[3] = pat & 0x04 ? color_on : color_off;
		col[4] = pat & 0x08 ? color_on : color_off;
		col[5] = pat & 0x10 ? color_on : color_off;
		col[6] = pat & 0x20 ? color_on : color_off;
		col[7] = pat & 0x40 ? color_on : color_off;
		col[8] = pat & 0x80 ? color_on : color_off;
		for(int y = 0; y < LED_SIZE_Y; y++) {
			scrntype_t* dest = emu->get_screen_buffer(vm_ranges[i].y + y) + vm_ranges[i].x;
			for(int x = 0; x < LED_SIZE_X; x++) {
				dest[x] = col[led_pattern[y][x]];
			}
		}
	}
}

#define STATE_VERSION	1

bool DISPLAY::process_state(FILEIO* state_fio, bool loading)
{
	if(!state_fio->StateCheckUint32(STATE_VERSION)) {
		return false;
	}
	if(!state_fio->StateCheckInt32(this_device_id)) {
		return false;
	}
	state_fio->StateArray(led, sizeof(led), 1);
	state_fio->StateValue(sel);
	return true;
}

