/*
	MS-DOS Player for Win32 console

	Author : Takeda.Toshiya
	Date   : 2025.06.22-
*/

#ifndef _LANG_RU_H_
#define _LANG_RU_H_

/* ----------------------------------------------------------------------------
	Russian messages (866: DOS Cyrillic Russian)
---------------------------------------------------------------------------- */

// Invalid function
const BYTE standard_error_russian_01[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xA0,0xEF,0x20,0xE4,0xE3,0xAD,0xAA,0xE6,0xA8,0xEF,0x00};
// File not found
const BYTE standard_error_russian_02[] = {0x94,0xA0,0xA9,0xAB,0x20,0xAD,0xA5,0x20,0xAD,0xA0,0xA9,0xA4,0xA5,0xAD,0x00};
// Path not found
const BYTE standard_error_russian_03[] = {0x8F,0xE3,0xE2,0xEC,0x20,0xAD,0xA5,0x20,0xAD,0xA0,0xA9,0xA4,0xA5,0xAD,0x00};
// Too many open files
const BYTE standard_error_russian_04[] = {0x91,0xAB,0xA8,0xE8,0xAA,0xAE,0xAC,0x20,0xAC,0xAD,0xAE,0xA3,0xAE,0x20,0xAE,0xE2,0xAA,0xE0,0xEB,0xE2,0xEB,0xE5,0x20,0xE4,0xA0,0xA9,0xAB,0xAE,0xA2,0x00};
// Access denied
const BYTE standard_error_russian_05[] = {0x84,0xAE,0xE1,0xE2,0xE3,0xAF,0x20,0xAD,0xA5,0xA2,0xAE,0xA7,0xAC,0xAE,0xA6,0xA5,0xAD,0x00};
// Invalid handle
const BYTE standard_error_russian_06[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xE3,0xAA,0xA0,0xA7,0xA0,0xE2,0xA5,0xAB,0xEC,0x00};
// Memory control blocks destroyed
const BYTE standard_error_russian_07[] = {0x90,0xA0,0xA7,0xE0,0xE3,0xE8,0xA5,0xAD,0x20,0xA1,0xAB,0xAE,0xAA,0x20,0xE3,0xAF,0xE0,0xA0,0xA2,0xAB,0xA5,0xAD,0xA8,0xEF,0x20,0xAF,0xA0,0xAC,0xEF,0xE2,0xEC,0xEE,0x00};
// Insufficient memory
const BYTE standard_error_russian_08[] = {0x8D,0xA5,0xA4,0xAE,0xE1,0xE2,0xA0,0xE2,0xAE,0xE7,0xAD,0xAE,0x20,0xAF,0xA0,0xAC,0xEF,0xE2,0xA8,0x00};
// Invalid memory block address
const BYTE standard_error_russian_09[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xA0,0xA4,0xE0,0xA5,0xE1,0x20,0xA1,0xAB,0xAE,0xAA,0xA0,0x20,0xAF,0xA0,0xAC,0xEF,0xE2,0xA8,0x00};
// Invalid Environment
const BYTE standard_error_russian_0A[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xAE,0xA5,0x20,0xAE,0xAA,0xE0,0xE3,0xA6,0xA5,0xAD,0xA8,0xA5,0x00};
// Invalid format
const BYTE standard_error_russian_0B[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xE4,0xAE,0xE0,0xAC,0xA0,0xE2,0x00};
// Invalid function parameter
const BYTE standard_error_russian_0C[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0x20,0xE4,0xE3,0xAD,0xAA,0xE6,0xA8,0xA8,0x00};
// Invalid data
const BYTE standard_error_russian_0D[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA5,0x20,0xA4,0xA0,0xAD,0xAD,0xEB,0xA5,0x00};
// Invalid drive specification
const BYTE standard_error_russian_0F[] = {0x8D,0xA5,0xAF,0xE0,0xA0,0xA2,0xA8,0xAB,0xEC,0xAD,0xAE,0x20,0xE3,0xAA,0xA0,0xA7,0xA0,0xAD,0xAE,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x00};
// Attempt to remove current directory
const BYTE standard_error_russian_10[] = {0x8F,0xAE,0xAF,0xEB,0xE2,0xAA,0xA0,0x20,0xE3,0xA4,0xA0,0xAB,0xA8,0xE2,0xEC,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA8,0xA9,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0x00};
// Not same device
const BYTE standard_error_russian_11[] = {0x8D,0xA5,0x20,0xE2,0xAE,0x20,0xA6,0xA5,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x00};
// No more files
const BYTE standard_error_russian_12[] = {0x81,0xAE,0xAB,0xEC,0xE8,0xA5,0x20,0xAD,0xA5,0xE2,0x20,0xE4,0xA0,0xA9,0xAB,0xAE,0xA2,0x00};

// Write protect error
const BYTE critical_error_russian_00[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xA7,0xA0,0xE9,0xA8,0xE2,0xEB,0x20,0xA7,0xA0,0xAF,0xA8,0xE1,0xA8,0x00};
// Invalid unit
const BYTE critical_error_russian_01[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xAE,0xA5,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x00};
// Not ready
const BYTE critical_error_russian_02[] = {0x8D,0xA5,0xE2,0x20,0xA3,0xAE,0xE2,0xAE,0xA2,0xAD,0xAE,0xE1,0xE2,0xA8,0x00};
// Invalid device request
const BYTE critical_error_russian_03[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xA7,0xA0,0xAF,0xE0,0xAE,0xE1,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xA0,0x00};
// Data error
const BYTE critical_error_russian_04[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xA2,0x20,0xA4,0xA0,0xAD,0xAD,0xEB,0xE5,0x00};
// Invalid device request parameters
const BYTE critical_error_russian_05[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA5,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xEB,0x20,0xA2,0x20,0xA7,0xA0,0xAF,0xE0,0xAE,0xE1,0xA5,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xA0,0x00};
// Seek error
const BYTE critical_error_russian_06[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xAF,0xAE,0xA7,0xA8,0xE6,0xA8,0xAE,0xAD,0xA8,0xE0,0xAE,0xA2,0xA0,0xAD,0xA8,0xEF,0x00};
// Invalid media type
const BYTE critical_error_russian_07[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xE2,0xA8,0xAF,0x20,0xAD,0xAE,0xE1,0xA8,0xE2,0xA5,0xAB,0xEF,0x00};
// Sector not found
const BYTE critical_error_russian_08[] = {0x91,0xA5,0xAA,0xE2,0xAE,0xE0,0x20,0xAD,0xA5,0x20,0xAD,0xA0,0xA9,0xA4,0xA5,0xAD,0x00};
// Printer out of paper error
const BYTE critical_error_russian_09[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xAF,0xE0,0xA8,0xAD,0xE2,0xA5,0xE0,0xA0,0x3A,0x20,0xAD,0xA5,0xE2,0x20,0xA1,0xE3,0xAC,0xA0,0xA3,0xA8,0x00};
// Write fault error
const BYTE critical_error_russian_0A[] = {0x8D,0xA5,0xA8,0xE1,0xAF,0xE0,0xA0,0xA2,0xA8,0xAC,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xA7,0xA0,0xAF,0xA8,0xE1,0xA8,0x00};
// Read fault error
const BYTE critical_error_russian_0B[] = {0x8D,0xA5,0xA8,0xE1,0xAF,0xE0,0xA0,0xA2,0xA8,0xAC,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xE7,0xE2,0xA5,0xAD,0xA8,0xEF,0x00};
// General failure
const BYTE critical_error_russian_0C[] = {0x83,0xAB,0xAE,0xA1,0xA0,0xAB,0xEC,0xAD,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x00};
// Sharing violation
const BYTE critical_error_russian_0D[] = {0x8D,0xA0,0xE0,0xE3,0xE8,0xA5,0xAD,0xA8,0xA5,0x20,0xE1,0xAE,0xA2,0xAC,0xA5,0xE1,0xE2,0xAD,0xAE,0xA3,0xAE,0x20,0xA8,0xE1,0xAF,0xAE,0xAB,0xEC,0xA7,0xAE,0xA2,0xA0,0xAD,0xA8,0xEF,0x00};
// Lock violation
const BYTE critical_error_russian_0E[] = {0x8D,0xA0,0xE0,0xE3,0xE8,0xA5,0xAD,0xA8,0xA5,0x20,0xA1,0xAB,0xAE,0xAA,0xA8,0xE0,0xAE,0xA2,0xAA,0xA8,0x00};
// Invalid disk change
const BYTE critical_error_russian_0F[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xA0,0xEF,0x20,0xE1,0xAC,0xA5,0xAD,0xA0,0x20,0xA4,0xA8,0xE1,0xAA,0xA5,0xE2,0xEB,0x00};
// FCB unavailable
const BYTE critical_error_russian_10[] = {0x46,0x43,0x42,0x20,0xAD,0xA5,0x20,0xA4,0xAE,0xE1,0xE2,0xE3,0xAF,0xA5,0xAD,0x00};
// System resource exhausted
const BYTE critical_error_russian_11[] = {0x91,0xA8,0xE1,0xE2,0xA5,0xAC,0xAD,0xEB,0xA5,0x20,0xE0,0xA5,0xE1,0xE3,0xE0,0xE1,0xEB,0x20,0xA8,0xE1,0xE7,0xA5,0xE0,0xAF,0xA0,0xAD,0xEB,0x00};
// Code page mismatch
const BYTE critical_error_russian_12[] = {0x8D,0xA5,0xE1,0xAE,0xA2,0xAF,0xA0,0xA4,0xA0,0xEE,0xE9,0xA0,0xEF,0x20,0xAA,0xAE,0xA4,0xAE,0xA2,0xA0,0xEF,0x20,0xE1,0xE2,0xE0,0xA0,0xAD,0xA8,0xE6,0xA0,0x00};
// Out of input
const BYTE critical_error_russian_13[] = {0x8D,0xA5,0xE2,0x20,0xA2,0xA2,0xAE,0xA4,0xA0,0x00};
// Insufficient disk space
const BYTE critical_error_russian_14[] = {0x8D,0xA5,0xA4,0xAE,0xE1,0xE2,0xA0,0xE2,0xAE,0xE7,0xAD,0xAE,0x20,0xAC,0xA5,0xE1,0xE2,0xA0,0x20,0xAD,0xA0,0x20,0xA4,0xA8,0xE1,0xAA,0xA5,0x00};

// File exists
const BYTE standard_error_russian_50[] = {0x94,0xA0,0xA9,0xAB,0x20,0xE1,0xE3,0xE9,0xA5,0xE1,0xE2,0xA2,0xE3,0xA5,0xE2,0x00};
// Cannot make directory entry
const BYTE standard_error_russian_52[] = {0x8D,0xA5,0xA2,0xAE,0xA7,0xAC,0xAE,0xA6,0xAD,0xAE,0x20,0xE1,0xAE,0xA7,0xA4,0xA0,0xE2,0xEC,0x20,0xED,0xAB,0xA5,0xAC,0xA5,0xAD,0xE2,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0xA0,0x00};
// Fail on INT 24
const BYTE standard_error_russian_53[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xA2,0x20,0xAF,0xE0,0xA5,0xE0,0xEB,0xA2,0xA0,0xAD,0xA8,0xA8,0x20,0x32,0x34,0x00};
// Too many redirections
const BYTE standard_error_russian_54[] = {0x91,0xAB,0xA8,0xE8,0xAA,0xAE,0xAC,0x20,0xAC,0xAD,0xAE,0xA3,0xAE,0x20,0xAF,0xA5,0xE0,0xA5,0xAD,0xA0,0xAF,0xE0,0xA0,0xA2,0xAB,0xA5,0xAD,0xA8,0xA9,0x00};
// Duplicate redirection
const BYTE standard_error_russian_55[] = {0x84,0xE3,0xA1,0xAB,0xA8,0xE0,0xAE,0xA2,0xA0,0xAD,0xAD,0xAE,0xA5,0x20,0xAF,0xA5,0xE0,0xA5,0xAD,0xA0,0xAF,0xE0,0xA0,0xA2,0xAB,0xA5,0xAD,0xA8,0xA5,0x00};
// Invalid password
const BYTE standard_error_russian_56[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xAF,0xA0,0xE0,0xAE,0xAB,0xEC,0x00};
// Invalid parameter
const BYTE standard_error_russian_57[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0x00};
// Network data fault
const BYTE standard_error_russian_58[] = {0x8E,0xE8,0xA8,0xA1,0xAA,0xA0,0x20,0xA2,0x20,0xE1,0xA5,0xE2,0xA5,0xA2,0xEB,0xE5,0x20,0xA4,0xA0,0xAD,0xAD,0xEB,0xE5,0x00};
// Function not supported by network
const BYTE standard_error_russian_59[] = {0x94,0xE3,0xAD,0xAA,0xE6,0xA8,0xEF,0x20,0xAD,0xA5,0x20,0xAF,0xAE,0xA4,0xA4,0xA5,0xE0,0xA6,0xA8,0xA2,0xA0,0xA5,0xE2,0xE1,0xEF,0x20,0xA4,0xAB,0xEF,0x20,0xE1,0xA5,0xE2,0xA8,0x00};
// Required system component not installed
const BYTE standard_error_russian_5A[] = {0x92,0xE0,0xA5,0xA1,0xE3,0xA5,0xAC,0xA0,0xEF,0x20,0xE1,0xA8,0xE1,0xE2,0xA5,0xAC,0xAD,0xA0,0xEF,0x20,0xAA,0xAE,0xAC,0xAF,0xAE,0xAD,0xA5,0xAD,0xE2,0xA0,0x20,0xAD,0xA5,0x20,0xE3,0xE1,0xE2,0xA0,0xAD,0xAE,0xA2,0xAB,0xA5,0xAD,0xA0,0x00};

// Unknown error
const BYTE standard_error_russian_64[] = {0x8D,0xA5,0xA8,0xA7,0xA2,0xA5,0xE1,0xE2,0xAD,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x00};
// Not ready
const BYTE standard_error_russian_65[] = {0x8D,0xA5,0xE2,0x20,0xA3,0xAE,0xE2,0xAE,0xA2,0xAD,0xAE,0xE1,0xE2,0xA8,0x00};
// EMS memory no longer valid
const BYTE standard_error_russian_66[] = {0x8F,0xA0,0xAC,0xEF,0xE2,0xEC,0x20,0x45,0x4D,0x53,0x20,0xA1,0xAE,0xAB,0xEC,0xE8,0xA5,0x20,0xAD,0xA5,0x20,0xA4,0xA5,0xA9,0xE1,0xE2,0xA2,0xA8,0xE2,0xA5,0xAB,0xEC,0xAD,0xA0,0x00};
// CDROM not High Sierra or ISO-9660 format
const BYTE standard_error_russian_67[] = {0x43,0x44,0x52,0x4F,0x4D,0x20,0xAD,0xA5,0x20,0xA2,0x20,0xE4,0xAE,0xE0,0xAC,0xA0,0xE2,0xA5,0x20,0x48,0x69,0x67,0x68,0x20,0x53,0x69,0x65,0x72,0x72,0x61,0x20,0xA8,0xAB,0xA8,0x20,0x49,0x53,0x4F,0x2D,0x39,0x36,0x36,0x30,0x00};
// Door open
const BYTE standard_error_russian_68[] = {0x84,0xA2,0xA5,0xE0,0xE6,0xA0,0x20,0xAE,0xE2,0xAA,0xE0,0xEB,0xE2,0xA0,0x00};

// Volume is not locked
const BYTE standard_error_russian_B0[] = {0x92,0xAE,0xAC,0x20,0xAD,0xA5,0x20,0xA7,0xA0,0xA1,0xAB,0xAE,0xAA,0xA8,0xE0,0xAE,0xA2,0xA0,0xAD,0x00};
// Volume is locked in drive
const BYTE standard_error_russian_B1[] = {0x92,0xAE,0xAC,0x20,0xA7,0xA0,0xA1,0xAB,0xAE,0xAA,0xA8,0xE0,0xAE,0xA2,0xA0,0xAD,0x20,0xA2,0x20,0xAF,0xE0,0xA8,0xA2,0xAE,0xA4,0xA5,0x00};
// Volume is not removable
const BYTE standard_error_russian_B2[] = {0x92,0xAE,0xAC,0x20,0xAD,0xA5,0x20,0xEF,0xA2,0xAB,0xEF,0xA5,0xE2,0xE1,0xEF,0x20,0xE1,0xEA,0xA5,0xAC,0xAD,0xEB,0xAC,0x00};
// Lock count has been exceeded
const BYTE standard_error_russian_B4[] = {0x91,0xE7,0xA5,0xE2,0xE7,0xA8,0xAA,0x20,0xA1,0xAB,0xAE,0xAA,0xA8,0xE0,0xAE,0xA2,0xAE,0xAA,0x20,0xA1,0xEB,0xAB,0x20,0xAF,0xE0,0xA5,0xA2,0xEB,0xE8,0xA5,0xAD,0x00};
// A valid eject request failed
const BYTE standard_error_russian_B5[] = {0x8D,0xA5,0x20,0xE3,0xA4,0xA0,0xAB,0xAE,0xE1,0xEC,0x20,0xA2,0xEB,0xAF,0xAE,0xAB,0xAD,0xA8,0xE2,0xEC,0x20,0xA4,0xAE,0xAF,0xE3,0xE1,0xE2,0xA8,0xAC,0xEB,0xA9,0x20,0xA7,0xA0,0xAF,0xE0,0xAE,0xE1,0x20,0xAD,0xA0,0x20,0xA8,0xA7,0xA2,0xAB,0xA5,0xE7,0xA5,0xAD,0xA8,0xA5,0x00};

// Too many parameters
const BYTE param_error_russian_01[] = {0x91,0xAB,0xA8,0xE8,0xAA,0xAE,0xAC,0x20,0xAC,0xAD,0xAE,0xA3,0xAE,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xAE,0xA2,0x00};
// Required parameter missing
const BYTE param_error_russian_02[] = {0x8E,0xA1,0xEF,0xA7,0xA0,0xE2,0xA5,0xAB,0xEC,0xAD,0xEB,0xA9,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0x20,0xAE,0xE2,0xE1,0xE3,0xE2,0xE1,0xE2,0xA2,0xE3,0xA5,0xE2,0x00};
// Invalid switch
const BYTE param_error_russian_03[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xAF,0xA5,0xE0,0xA5,0xAA,0xAB,0xEE,0xE7,0xA0,0xE2,0xA5,0xAB,0xEC,0x00};
// Invalid keyword
const BYTE param_error_russian_04[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xAE,0xA5,0x20,0xAA,0xAB,0xEE,0xE7,0xA5,0xA2,0xAE,0xA5,0x20,0xE1,0xAB,0xAE,0xA2,0xAE,0x00};
// Parameter value not in allowed range
const BYTE param_error_russian_06[] = {0x87,0xAD,0xA0,0xE7,0xA5,0xAD,0xA8,0xA5,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xA0,0x20,0xA2,0xAD,0xA5,0x20,0xA4,0xAE,0xAF,0xE3,0xE1,0xE2,0xA8,0xAC,0xAE,0xA3,0xAE,0x20,0xA4,0xA8,0xA0,0xAF,0xA0,0xA7,0xAE,0xAD,0xA0,0x00};
// Parameter value not allowed
const BYTE param_error_russian_07[] = {0x8D,0xA5,0xA4,0xAE,0xAF,0xE3,0xE1,0xE2,0xA8,0xAC,0xAE,0xA5,0x20,0xA7,0xAD,0xA0,0xE7,0xA5,0xAD,0xA8,0xA5,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xA0,0x00};
// Parameter value not allowed
const BYTE param_error_russian_08[] = {0x8D,0xA5,0xA4,0xAE,0xAF,0xE3,0xE1,0xE2,0xA8,0xAC,0xAE,0xA5,0x20,0xA7,0xAD,0xA0,0xE7,0xA5,0xAD,0xA8,0xA5,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xA0,0x00};
// Parameter format not correct
const BYTE param_error_russian_09[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xE4,0xAE,0xE0,0xAC,0xA0,0xE2,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xA0,0x00};
// Invalid parameter
const BYTE param_error_russian_0A[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xEB,0xA9,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0x00};
// Invalid parameter combination
const BYTE param_error_russian_0B[] = {0x8D,0xA5,0xA2,0xA5,0xE0,0xAD,0xA0,0xEF,0x20,0xAA,0xAE,0xAC,0xA1,0xA8,0xAD,0xA0,0xE6,0xA8,0xEF,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xAE,0xA2,0x00};

// Unknown error
const BYTE unknown_error_russian[] = {0x8D,0xA5,0xA8,0xA7,0xA2,0xA5,0xE1,0xE2,0xAD,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x00};
// Critical error
const BYTE critical_error_russian[] = {0x8A,0xE0,0xA8,0xE2,0xA8,0xE7,0xA5,0xE1,0xAA,0xA0,0xEF,0x20,0xAE,0xE8,0xA8,0xA1,0xAA,0xA0,0x00};

// writing drive
const BYTE writing_drive_russian[] = {0xA7,0xA0,0xAF,0xA8,0xE1,0xA8,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x00};
// reading drive
const BYTE reading_drive_russian[] = {0xE7,0xE2,0xA5,0xAD,0xA8,0xEF,0x20,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x00};

// Abort (A)
const BYTE abort_russian[] = {0x8F,0xE0,0xA5,0xAA,0xE0,0xA0,0xE2,0xA8,0xE2,0xEC,0x20,0x28,0x41,0x29,0x00};
// Retry (R)
const BYTE retry_russian[] = {0x8F,0xAE,0xA2,0xE2,0xAE,0xE0,0xA8,0xE2,0xEC,0x20,0x28,0x52,0x29,0x00};
// Igore (I)
const BYTE ignore_russian[] = {0x88,0xA3,0xAD,0xAE,0xE0,0xA8,0xE0,0xAE,0xA2,0xA0,0xE2,0xEC,0x20,0x28,0x49,0x29,0x00};
// Fail (F)
const BYTE fail_russian[] = {0x8E,0xE2,0xAC,0xA5,0xAD,0xA8,0xE2,0xEC,0x20,0x28,0x46,0x29,0x00};

/*
Displays or sets a search path for executable files.

PATH [[drive:]path[;...]]
PATH ;

Type PATH ; to clear all search-path settings and direct MS-DOS to search
only in the current directory.
Type PATH without parameters to display the current path.
*/
const BYTE help_path_russian[] = {
	0x8E,0xE2,0xAE,0xA1,0xE0,0xA0,0xA6,0xA0,0xA5,0xE2,0x20,0xA8,0xAB,0xA8,0x20,0xA7,0xA0,0xA4,0xA0,0xA5,0xE2,0x20,0xAF,0xE3,0xE2,0xEC,0x20,0xAF,0xAE,0xA8,0xE1,0xAA,0xA0,0x20,0xA4,0xAB,0xEF,0x20,0xA2,0xEB,0xAF,0xAE,0xAB,0xAD,0xEF,0xA5,0xAC,0xEB,0xE5,0x20,0xE4,0xA0,0xA9,0xAB,0xAE,0xA2,0x0D,0x0A,
	0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x5B,0x5B,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0x3A,0x5D,0xAF,0xE3,0xE2,0xEC,0x5B,0x3B,0x2E,0x2E,0x2E,0x5D,0x5D,0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x3B,0x0D,0x0A,
	0x0D,0x0A,
	0x82,0xA2,0xA5,0xA4,0xA8,0xE2,0xA5,0x20,0x50,0x41,0x54,0x48,0x20,0x3B,0x2C,0x20,0xE7,0xE2,0xAE,0xA1,0xEB,0x20,0xE3,0xA4,0xA0,0xAB,0xA8,0xE2,0xEC,0x20,0xA2,0xE1,0xA5,0x20,0xE3,0xE1,0xE2,0xA0,0xAD,0xAE,0xA2,0xAA,0xA8,0x20,0xAF,0xE3,0xE2,0xA8,0x20,0xAF,0xAE,0xA8,0xE1,0xAA,0xA0,0x20,0xA8,0x20,0xA7,0xA0,0xA4,0xA0,0xE2,0xEC,0x20,0xAF,0xAE,0xA8,0xE1,0xAA,0x0D,0x0A,
	0xE2,0xAE,0xAB,0xEC,0xAA,0xAE,0x20,0xA2,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA5,0xAC,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0xA5,0x0D,0x0A,
	0x82,0xA2,0xA5,0xA4,0xA8,0xE2,0xA5,0x20,0x50,0x41,0x54,0x48,0x20,0xA1,0xA5,0xA7,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xAE,0xA2,0x2C,0x20,0xE7,0xE2,0xAE,0xA1,0xEB,0x20,0xAE,0xE2,0xAE,0xA1,0xE0,0xA0,0xA7,0xA8,0xE2,0xEC,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA8,0xA9,0x20,0xAF,0xE3,0xE2,0xEC,0x0D,0x0A,0x00
};

/*
Displays, sets, or removes MS-DOS environment variables.

SET [variable=[string]]

  variable  Specifies the environment-variable name.
  string    Specifies a series of characters to assign to the variable.

Type SET without parameters to display the current environment variables.
*/
const BYTE help_set_russian[] = {
	0x8E,0xE2,0xAE,0xA1,0xE0,0xA0,0xA6,0xA0,0xA5,0xE2,0x2C,0x20,0xAD,0xA0,0xA7,0xAD,0xA0,0xE7,0xA0,0xA5,0xE2,0x20,0xA8,0xAB,0xA8,0x20,0xAE,0xE2,0xAC,0xA5,0xAD,0xEF,0xA5,0xE2,0x20,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xEB,0xA5,0x20,0xE1,0xE0,0xA5,0xA4,0xEB,0x20,0x4D,0x53,0x2D,0x44,0x4F,0x53,0x0D,0x0A,
	0x0D,0x0A,
	0x53,0x45,0x54,0x20,0x5B,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xA0,0xEF,0x3D,0x5B,0xE1,0xE2,0xE0,0xAE,0xAA,0xA0,0x5D,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xA0,0xEF,0x20,0x20,0x20,0x20,0x93,0xAA,0xA0,0xA7,0xEB,0xA2,0xA0,0xA5,0xE2,0x20,0xA8,0xAC,0xEF,0x20,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xAE,0xA9,0x20,0xE1,0xE0,0xA5,0xA4,0xEB,0x0D,0x0A,
	0x20,0x20,0xE1,0xE2,0xE0,0xAE,0xAA,0xA0,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x93,0xAA,0xA0,0xA7,0xEB,0xA2,0xA0,0xA5,0xE2,0x20,0xE1,0xA8,0xAC,0xA2,0xAE,0xAB,0xEB,0x20,0xA4,0xAB,0xEF,0x20,0xE3,0xE1,0xE2,0xA0,0xAD,0xAE,0xA2,0xAA,0xA8,0x20,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xAE,0xA9,0x0D,0x0A,
	0x0D,0x0A,
	0x82,0xA2,0xA5,0xA4,0xA8,0xE2,0xA5,0x20,0x53,0x45,0x54,0x20,0xA1,0xA5,0xA7,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xAE,0xA2,0x20,0xA4,0xAB,0xEF,0x20,0xAE,0xE2,0xAE,0xA1,0xE0,0xA0,0xA6,0xA5,0xAD,0xA8,0xEF,0x20,0xA2,0xE1,0xA5,0xE5,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA8,0xE5,0x20,0xAF,0xA5,0xE0,0xA5,0xAC,0xA5,0xAD,0xAD,0xEB,0xE5,0x20,0xE1,0xE0,0xA5,0xA4,0xEB,0x0D,0x0A,0x00
};

/*
Displays the name of or changes the current directory.

CHDIR [drive:][path]
CHDIR[..]
CD [drive:][path]
CD[..]

  ..   Specifies that you want to change to the parent directory.

Type CD drive: to display the current directory in the specified drive.
Type CD without parameters to display the current drive and directory.
*/
const BYTE help_chdir_russian[] = {
	0x8E,0xE2,0xAE,0xA1,0xE0,0xA0,0xA6,0xA0,0xA5,0xE2,0x20,0xA8,0xAB,0xA8,0x20,0xA8,0xA7,0xAC,0xA5,0xAD,0xEF,0xA5,0xE2,0x20,0xA8,0xAC,0xEF,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA5,0xA3,0xAE,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0xA0,0x0D,0x0A,
	0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x20,0x5B,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0x3A,0x5D,0x5B,0xAF,0xE3,0xE2,0xEC,0x5D,0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x43,0x44,0x20,0x5B,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0x3A,0x5D,0x5B,0xAF,0xE3,0xE2,0xEC,0x5D,0x0D,0x0A,
	0x43,0x44,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0x2E,0x2E,0x20,0x20,0x20,0x93,0xAA,0xA0,0xA7,0xEB,0xA2,0xA0,0xA5,0xE2,0x2C,0x20,0xE7,0xE2,0xAE,0x20,0x82,0xEB,0x20,0xE5,0xAE,0xE2,0xA8,0xE2,0xA5,0x20,0xE1,0xAC,0xA5,0xAD,0xA8,0xE2,0xEC,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0x20,0xAD,0xA0,0x20,0xE0,0xAE,0xA4,0xA8,0xE2,0xA5,0xAB,0xEC,0xE1,0xAA,0xA8,0xA9,0x0D,0x0A,
	0x0D,0x0A,
	0x82,0xA2,0xA5,0xA4,0xA8,0xE2,0xA5,0x20,0x43,0x44,0x20,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0x3A,0x2C,0x20,0xE7,0xE2,0xAE,0xA1,0xEB,0x20,0xAF,0xAE,0xAB,0xE3,0xE7,0xA8,0xE2,0xEC,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA8,0xA9,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0x20,0xA2,0x20,0xE3,0xAA,0xA0,0xA7,0xA0,0xAD,0xAD,0xAE,0xAC,0x20,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0xA5,0x0D,0x0A,
	0x82,0xA2,0xA5,0xA4,0xA8,0xE2,0xA5,0x20,0x43,0x44,0x20,0xA1,0xA5,0xA7,0x20,0xAF,0xA0,0xE0,0xA0,0xAC,0xA5,0xE2,0xE0,0xAE,0xA2,0x2C,0x20,0xE7,0xE2,0xAE,0xA1,0xEB,0x20,0xAF,0xAE,0xAB,0xE3,0xE7,0xA8,0xE2,0xEC,0x20,0xE2,0xA5,0xAA,0xE3,0xE9,0xA8,0xA9,0x20,0xA4,0xA8,0xE1,0xAA,0xAE,0xA2,0xAE,0xA4,0x20,0xA8,0x20,0xAA,0xA0,0xE2,0xA0,0xAB,0xAE,0xA3,0x0D,0x0A,0x00
};

/*
Displays the contents of text files.

TYPE [drive:][path]filename
*/
const BYTE help_type_russian[] = {
	0x8F,0xAE,0xAA,0xA0,0xA7,0xEB,0xA2,0xA0,0xA5,0xE2,0x20,0xE1,0xAE,0xA4,0xA5,0xE0,0xA6,0xA8,0xAC,0xAE,0xA5,0x20,0xE2,0xA5,0xAA,0xE1,0xE2,0xAE,0xA2,0xAE,0xA3,0xAE,0x20,0xE4,0xA0,0xA9,0xAB,0xA0,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x59,0x50,0x45,0x20,0x5B,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x3A,0x5D,0x5B,0xAF,0xE3,0xE2,0xEC,0x5D,0xA8,0xAC,0xEF,0x5F,0xE4,0xA0,0xA9,0xAB,0xA0,0x0D,0x0A,0x00
};

/*
Displays the MS-DOS Version.

VER
*/
const BYTE help_ver_russian[] = {
	0x8E,0xE2,0xAE,0xA1,0xE0,0xA0,0xA6,0xA0,0xA5,0xE2,0x20,0xA2,0xA5,0xE0,0xE1,0xA8,0xEE,0x20,0x4D,0x53,0x2D,0x44,0x4F,0x53,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x56,0x45,0x52,0x0D,0x0A,0x00
};

/*
Returns a fully qualified filename.

TRUENAME [drive:][path]filename
*/
const BYTE help_truename_russian[] = {
	0x82,0xAE,0xA7,0xA2,0xE0,0xA0,0xE9,0xA0,0xA5,0xE2,0x20,0xAF,0xAE,0xAB,0xAD,0xAE,0xA5,0x20,0xA8,0xAC,0xEF,0x20,0xE4,0xA0,0xA9,0xAB,0xA0,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x52,0x55,0x45,0x4E,0x41,0x4D,0x45,0x20,0x5B,0xE3,0xE1,0xE2,0xE0,0xAE,0xA9,0xE1,0xE2,0xA2,0xAE,0x3A,0x5D,0x5B,0xAF,0xE3,0xE2,0xEC,0x5D,0xA8,0xAC,0xEF,0x5F,0xE4,0xA0,0xA9,0xAB,0xA0,0x0D,0x0A,0x00
};

#endif
