/*
	MS-DOS Player for Win32 console

	Author : Takeda.Toshiya
	Date   : 2024.07.14-
*/

#ifndef _LANG_KO_H_
#define _LANG_KO_H_

/* ----------------------------------------------------------------------------
	Korean messages (949: KS C 5601)
---------------------------------------------------------------------------- */

// Invalid function
const BYTE standard_error_korean_01[] = {0xB1,0xE2,0xB4,0xC9,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// File not found
const BYTE standard_error_korean_02[] = {0xC6,0xC4,0xC0,0xCF,0xC0,0xCC,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Path not found
const BYTE standard_error_korean_03[] = {0xB0,0xE6,0xB7,0xCE,0xB0,0xA1,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Too many open files
const BYTE standard_error_korean_04[] = {0xBF,0xAD,0xB8,0xB0,0x20,0xC6,0xC4,0xC0,0xCF,0xC0,0xCC,0x20,0xB3,0xCA,0xB9,0xAB,0x20,0xB8,0xB9,0xC0,0xBD,0x00};
// Access denied
const BYTE standard_error_korean_05[] = {0xBB,0xE7,0xBF,0xEB,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Invalid handle
const BYTE standard_error_korean_06[] = {0xBB,0xE7,0xBF,0xEB,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xB4,0xC2,0x20,0xC7,0xDA,0xB5,0xE9,0xC0,0xD3,0x00};
// Memory control blocks destroyed
const BYTE standard_error_korean_07[] = {0xB8,0xDE,0xB8,0xF0,0xB8,0xAE,0x20,0xC1,0xA6,0xBE,0xEE,0x20,0xBA,0xED,0xB7,0xB0,0xC0,0xCC,0x20,0xC6,0xC4,0xB1,0xAB,0xB5,0xC7,0xBE,0xFA,0xC0,0xBD,0x00};
// Insufficient memory
const BYTE standard_error_korean_08[] = {0xB8,0xDE,0xB8,0xF0,0xB8,0xAE,0xB0,0xA1,0x20,0xBA,0xCE,0xC1,0xB7,0xC7,0xD4,0x00};
// Invalid memory block address
const BYTE standard_error_korean_09[] = {0xB8,0xDE,0xB8,0xF0,0xB8,0xAE,0x20,0xBA,0xED,0xB7,0xB0,0x20,0xB9,0xF8,0xC1,0xF6,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid Environment
const BYTE standard_error_korean_0A[] = {0xC8,0xAF,0xB0,0xE6,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid format
const BYTE standard_error_korean_0B[] = {0xC7,0xFC,0xBD,0xC4,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid function parameter
const BYTE standard_error_korean_0C[] = {0xB1,0xE2,0xB4,0xC9,0x20,0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid data
const BYTE standard_error_korean_0D[] = {0xB5,0xA5,0xC0,0xCC,0xC5,0xCD,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid drive specification
const BYTE standard_error_korean_0F[] = {0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x20,0xC1,0xF6,0xC1,0xA4,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Attempt to remove current directory
const BYTE standard_error_korean_10[] = {0xC7,0xF6,0xC0,0xE7,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xE4,0xB8,0xAE,0x20,0xBB,0xE8,0xC1,0xA6,0x00};
// Not same device
const BYTE standard_error_korean_11[] = {0xB5,0xBF,0xC0,0xCF,0xC7,0xD1,0x20,0xC0,0xE5,0xC4,0xA1,0xB0,0xA1,0x20,0xBE,0xC6,0xB4,0xD4,0x00};
// No more files
const BYTE standard_error_korean_12[] = {0xB4,0xF5,0x20,0xC0,0xCC,0xBB,0xF3,0x20,0xC6,0xC4,0xC0,0xCF,0xC0,0xCC,0x20,0xBE,0xF8,0xC0,0xBD,0x00};

// Write protect error
const BYTE critical_error_korean_00[] = {0xBE,0xB2,0xB1,0xE2,0xB1,0xDD,0xC1,0xF6,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// Invalid unit
const BYTE critical_error_korean_01[] = {0xB4,0xDC,0xC0,0xA7,0xB0,0xA1,0x20,0xC6,0xB2,0xB7,0xC8,0xC0,0xBD,0x00};
// Not ready
const BYTE critical_error_korean_02[] = {0xC1,0xD8,0xBA,0xF1,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xBE,0xD2,0xC0,0xBD,0x00};
// Invalid device request
const BYTE critical_error_korean_03[] = {0xBF,0xE4,0xB1,0xB8,0xB5,0xC8,0x20,0xC0,0xE5,0xC4,0xA1,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Data error
const BYTE critical_error_korean_04[] = {0xB5,0xA5,0xC0,0xCC,0xC5,0xCD,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// Invalid device request parameters
const BYTE critical_error_korean_05[] = {0xC0,0xE5,0xC4,0xA1,0xBF,0xA1,0x20,0xC7,0xCA,0xBF,0xE4,0xC7,0xD1,0x20,0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Seek error
const BYTE critical_error_korean_06[] = {0xC3,0xA3,0xB1,0xE2,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// Invalid media type
const BYTE critical_error_korean_07[] = {0xB8,0xC5,0xC3,0xBC,0x20,0xC1,0xBE,0xB7,0xF9,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Sector not found
const BYTE critical_error_korean_08[] = {0xBC,0xBD,0xC5,0xCD,0xB8,0xA6,0x20,0xC3,0xA3,0xC0,0xBB,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Printer out of paper error
const BYTE critical_error_korean_09[] = {0xC7,0xC1,0xB8,0xB0,0xC5,0xCD,0xBF,0xA1,0x20,0xBF,0xEB,0xC1,0xF6,0xB0,0xA1,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Write fault error
const BYTE critical_error_korean_0A[] = {0xBE,0xB5,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xB4,0xC2,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// Read fault error
const BYTE critical_error_korean_0B[] = {0xC0,0xD0,0xC0,0xBB,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xB4,0xC2,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// General failure
const BYTE critical_error_korean_0C[] = {0xC0,0xCF,0xB9,0xDD,0x20,0xBF,0xC0,0xB7,0xF9,0x00};
// Sharing violation
const BYTE critical_error_korean_0D[] = {0xB0,0xF8,0xC0,0xAF,0x20,0xBF,0xF8,0xC4,0xA2,0xC0,0xBB,0x20,0xBE,0xEE,0xB0,0xE5,0xC0,0xBD,0x00};
// Lock violation
const BYTE critical_error_korean_0E[] = {0xBA,0xB8,0xC8,0xA3,0x20,0xBF,0xF8,0xC4,0xA2,0xC0,0xBB,0x20,0xBE,0xEE,0xB0,0xE5,0xC0,0xBD,0x00};
// Invalid disk change
const BYTE critical_error_korean_0F[] = {0xB5,0xF0,0xBD,0xBA,0xC5,0xA9,0x20,0xB1,0xB3,0xC8,0xAF,0xC0,0xCC,0x20,0xC0,0xDF,0xB8,0xF8,0xB5,0xC7,0xBE,0xFA,0xC0,0xBD,0x00};
// FCB unavailable
const BYTE critical_error_korean_10[] = {0x46,0x43,0x42,0xB8,0xA6,0x20,0xBB,0xE7,0xBF,0xEB,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// System resource exhausted
const BYTE critical_error_korean_11[] = {0xBD,0xC3,0xBD,0xBA,0xC5,0xDB,0xBF,0xA1,0x20,0xBB,0xE7,0xBF,0xEB,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xC0,0xD6,0xB4,0xC2,0x20,0xC0,0xE5,0xC4,0xA1,0xB0,0xA1,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Code page mismatch
const BYTE critical_error_korean_12[] = {0xC4,0xDA,0xB5,0xE5,0xC6,0xE4,0xC0,0xCC,0xC1,0xF6,0xB0,0xA1,0x20,0xB8,0xC2,0xC1,0xF6,0x20,0xBE,0xCA,0xC0,0xBD,0x00};
// Out of input
const BYTE critical_error_korean_13[] = {0xC0,0xD4,0xB7,0xC2,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Insufficient disk space
const BYTE critical_error_korean_14[] = {0xB5,0xF0,0xBD,0xBA,0xC5,0xA9,0x20,0xBF,0xEB,0xB7,0xAE,0xC0,0xCC,0x20,0xBA,0xCE,0xC1,0xB7,0xC7,0xD4,0x00};

// File exists
const BYTE standard_error_korean_50[] = {0xC6,0xC4,0xC0,0xCF,0xC0,0xCC,0x20,0xC0,0xD6,0xC0,0xBD,0x00};
// Cannot make directory entry
const BYTE standard_error_korean_52[] = {0xB5,0xF0,0xB7,0xBA,0xC5,0xE4,0xB8,0xAE,0x20,0xC7,0xD7,0xB8,0xF1,0xC0,0xBB,0x20,0xB8,0xB8,0xB5,0xE9,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Fail on INT 24
const BYTE standard_error_korean_53[] = {0x49,0x4E,0x54,0x20,0x32,0x34,0x20,0xBD,0xC7,0xC6,0xD0,0x00};
// Too many redirections
const BYTE standard_error_korean_54[] = {0xB9,0xE6,0xC7,0xE2,0xC0,0xFC,0xC8,0xAF,0xC0,0xCC,0x20,0xB3,0xCA,0xB9,0xAB,0x20,0xB8,0xB9,0xC0,0xBD,0x00};
// Duplicate redirection
const BYTE standard_error_korean_55[] = {0xB9,0xE6,0xC7,0xE2,0xC0,0xFC,0xC8,0xAF,0xC0,0xCC,0x20,0xC1,0xDF,0xBA,0xB9,0xB5,0xC7,0xBE,0xFA,0xC0,0xBD,0x00};
// Invalid password
const BYTE standard_error_korean_56[] = {0xBE,0xCF,0xC8,0xA3,0xB8,0xED,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid parameter
const BYTE standard_error_korean_57[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Network data fault
const BYTE standard_error_korean_58[] = {0xB3,0xD7,0xC6,0xAE,0xBF,0xF6,0xC5,0xA9,0x20,0xC1,0xA4,0xBA,0xB8,0xB0,0xA1,0x20,0xC0,0xDF,0xB8,0xF8,0xB5,0xC7,0xBE,0xFA,0xC0,0xBD,0x00};
// Function not supported by network
const BYTE standard_error_korean_59[] = {0xB3,0xD7,0xC6,0xAE,0xBF,0xF6,0xC5,0xA9,0xBF,0xA1,0xBC,0xAD,0x20,0xC1,0xF6,0xBF,0xF8,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xB4,0xC2,0x20,0xB1,0xE2,0xB4,0xC9,0xC0,0xD3,0x00};
// Required system component not installed
const BYTE standard_error_korean_5A[] = {0xC7,0xCA,0xBF,0xE4,0xC7,0xD1,0x20,0xBD,0xC3,0xBD,0xBA,0xC5,0xDB,0x20,0xBF,0xE4,0xBC,0xD2,0xB0,0xA1,0x20,0xBC,0xB3,0xC4,0xA1,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xBE,0xD2,0xC0,0xBD,0x00};

// Unknown error
const BYTE standard_error_korean_64[] = {0xBE,0xCB,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xB4,0xC2,0x20,0xBF,0xC0,0xB7,0xF9,0xC0,0xD4,0xB4,0xCF,0xB4,0xD9,0x00};
// Not ready
const BYTE standard_error_korean_65[] = {0xC1,0xD8,0xBA,0xF1,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xBE,0xD2,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// EMS memory no longer valid
const BYTE standard_error_korean_66[] = {0x45,0x4D,0x53,0x20,0xB8,0xDE,0xB8,0xF0,0xB8,0xAE,0xB0,0xA1,0x20,0xB4,0xF5,0x20,0xC0,0xCC,0xBB,0xF3,0x20,0xC0,0xAF,0xC8,0xBF,0xC7,0xCF,0xC1,0xF6,0x20,0xBE,0xCA,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// CDROM not High Sierra or ISO-9660 format
const BYTE standard_error_korean_67[] = {0x43,0x44,0x2D,0x52,0x4F,0x4D,0xC0,0xCC,0x20,0x48,0x69,0x67,0x68,0x20,0x53,0x69,0x65,0x72,0x72,0x61,0xB3,0xAA,0x20,0x49,0x53,0x4F,0x2D,0x39,0x36,0x36,0x30,0x20,0xC6,0xF7,0xB8,0xCB,0xC0,0xCC,0x20,0xBE,0xC6,0xB4,0xD5,0xB4,0xCF,0xB4,0xD9,0x00};
// Door open
const BYTE standard_error_korean_68[] = {0xB9,0xAE,0xC0,0xCC,0x20,0xBF,0xAD,0xB7,0xC1,0x20,0xC0,0xD6,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};

// Volume is not locked
const BYTE standard_error_korean_B0[] = {0xBA,0xBC,0xB7,0xFD,0xC0,0xCC,0x20,0xC0,0xE1,0xB0,0xDC,0x20,0xC0,0xD6,0xC1,0xF6,0x20,0xBE,0xCA,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// Volume is locked in drive
const BYTE standard_error_korean_B1[] = {0xBA,0xBC,0xB7,0xFD,0xC0,0xCC,0x20,0xC0,0xE1,0xB0,0xDC,0x20,0xC0,0xD6,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// Volume is not removable
const BYTE standard_error_korean_B2[] = {0xBA,0xBC,0xB7,0xFD,0xC0,0xBB,0x20,0xC1,0xA6,0xB0,0xC5,0xC7,0xD2,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// Lock count has been exceeded
const BYTE standard_error_korean_B4[] = {0xBA,0xBC,0xB7,0xFD,0xC0,0xBB,0x20,0xB4,0xF5,0x20,0xC0,0xCC,0xBB,0xF3,0x20,0xC0,0xE1,0xB1,0xDB,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};
// A valid eject request failed
const BYTE standard_error_korean_B5[] = {0xB2,0xA8,0xB3,0xBB,0xC1,0xF6,0x20,0xB8,0xF8,0xC7,0xDF,0xBD,0xC0,0xB4,0xCF,0xB4,0xD9,0x00};

// Too many parameters
const BYTE param_error_korean_01[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xB8,0xB9,0xC0,0xBD,0x00};
// Required parameter missing
const BYTE param_error_korean_02[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xBE,0xF8,0xC0,0xBD,0x00};
// Invalid switch
const BYTE param_error_korean_03[] = {0xBD,0xBA,0xC0,0xA7,0xC4,0xA1,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid keyword
const BYTE param_error_korean_04[] = {0xC1,0xDF,0xBD,0xC9,0xBE,0xEE,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Parameter value not in allowed range
const BYTE param_error_korean_06[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xB0,0xAA,0xC0,0xCC,0x20,0xB9,0xFC,0xC0,0xA7,0xB8,0xA6,0x20,0xB9,0xFE,0xBE,0xEE,0x20,0xB3,0xB5,0xC0,0xBD,0x00};
// Parameter value not allowed
const BYTE param_error_korean_07[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xB0,0xAA,0xC0,0xBA,0x20,0xC7,0xE3,0xBF,0xEB,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xC0,0xBD,0x00};
// Parameter value not allowed
const BYTE param_error_korean_08[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xB0,0xAA,0xC0,0xBA,0x20,0xC7,0xE3,0xBF,0xEB,0xB5,0xC7,0xC1,0xF6,0x20,0xBE,0xCA,0xC0,0xBD,0x00};
// Parameter format not correct
const BYTE param_error_korean_09[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xC7,0xFC,0xBD,0xC4,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid parameter
const BYTE param_error_korean_0A[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0xB0,0xA1,0x20,0xC6,0xB2,0xB8,0xB2,0x00};
// Invalid parameter combination
const BYTE param_error_korean_0B[] = {0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xC1,0xB6,0xC7,0xD5,0xC0,0xCC,0x20,0xC6,0xB2,0xB8,0xB2,0x00};

// Unknown error
const BYTE unknown_error_korean[] = {0xBE,0xCB,0x20,0xBC,0xF6,0x20,0xBE,0xF8,0xB4,0xC2,0x20,0xBF,0xC0,0xB7,0xF9,0xC0,0xD4,0xB4,0xCF,0xB4,0xD9,0x00};
// Critical error
const BYTE critical_error_korean[] = {0xC4,0xA1,0xB8,0xED,0xC0,0xFB,0xC0,0xCE,0x20,0xBF,0xC0,0xB7,0xF9,0xC0,0xD4,0xB4,0xCF,0xB4,0xD9,0x00};

// writing drive
const BYTE writing_drive_korean[] = {0xBE,0xB2,0xB4,0xC2,0x20,0xC1,0xDF,0x20,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x00};
// reading drive
const BYTE reading_drive_korean[] = {0xC0,0xD0,0xB4,0xC2,0x20,0xC1,0xDF,0x20,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x00};

// Abort (A)
const BYTE abort_korean[] = {0xC1,0xDF,0xC1,0xF6,0x20,0x28,0x41,0x29,0x00};
// Retry (R)
const BYTE retry_korean[] = {0xC0,0xE7,0xBD,0xC3,0xB5,0xB5,0x20,0x28,0x52,0x29,0x00};
// Igore (I)
const BYTE ignore_korean[] = {0xB9,0xAB,0xBD,0xC3,0x20,0x28,0x49,0x29,0x00};
// Fail (F)
const BYTE fail_korean[] = {0xBD,0xC7,0xC6,0xD0,0x20,0x28,0x46,0x29,0x00};

/*
Displays or sets a search path for executable files.

PATH [[drive:]path[;...]]
PATH ;

Type PATH ; to clear all search-path settings and direct MS-DOS to search
only in the current directory.
Type PATH without parameters to display the current path.
*/
const BYTE help_path_korean[] = {
	0xBD,0xC7,0xC7,0xE0,0x20,0xC6,0xC4,0xC0,0xCF,0xC0,0xBB,0x20,0xC3,0xA3,0xB4,0xC2,0x20,0xB0,0xE6,0xB7,0xCE,0xB8,0xA6,0x20,0xBC,0xB3,0xC1,0xA4,0xC7,0xCF,0xB0,0xC5,0xB3,0xAA,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x5B,0x5B,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x5D,0xB0,0xE6,0xB7,0xCE,0x20,0x5B,0x3B,0x2E,0x2E,0x2E,0x5D,0x5D,0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x3B,0x0D,0x0A,
	0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x3B,0xB8,0xA6,0x20,0xC0,0xD4,0xB7,0xC2,0xC7,0xCF,0xB8,0xE9,0x20,0xC1,0xF6,0xC1,0xA4,0xC7,0xD1,0x20,0xB0,0xE6,0xB7,0xCE,0xB8,0xA6,0x20,0xB8,0xF0,0xB5,0xCE,0x20,0xBB,0xE8,0xC1,0xA6,0xC7,0xCF,0xB0,0xED,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xBF,0xA1,0xBC,0xAD,0xB8,0xB8,0x0D,0x0A,
	0xB0,0xCB,0xBB,0xF6,0xC7,0xCF,0xB5,0xB5,0xB7,0xCF,0x20,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xCC,0x20,0xBB,0xE7,0xBF,0xEB,0xC7,0xCF,0xB8,0xE9,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xB0,0xE6,0xB7,0xCE,0xB8,0xA6,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,0x00
};

/*
Displays, sets, or removes MS-DOS environment variables.

SET [variable=[string]]

  variable  Specifies the environment-variable name.
  string    Specifies a series of characters to assign to the variable.

Type SET without parameters to display the current environment variables.
*/
const BYTE help_set_korean[] = {
	0x4D,0x53,0x2D,0x44,0x4F,0x53,0x20,0xC8,0xAF,0xB0,0xE6,0xBA,0xAF,0xBC,0xF6,0xB8,0xA6,0x20,0xC7,0xA5,0xBD,0xC3,0x2C,0x20,0xBC,0xB3,0xC1,0xA4,0x2C,0x20,0xBB,0xE8,0xC1,0xA6,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x53,0x45,0x54,0x20,0x5B,0xBA,0xAF,0xBC,0xF6,0x3D,0x5B,0xB9,0xAE,0xC0,0xDA,0xBF,0xAD,0x5D,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0xBA,0xAF,0xBC,0xF6,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0xC8,0xAF,0xB0,0xE6,0xBA,0xAF,0xBC,0xF6,0x20,0xC0,0xCC,0xB8,0xA7,0xC0,0xBB,0x20,0xC1,0xF6,0xC1,0xA4,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x20,0x20,0xB9,0xAE,0xC0,0xDA,0xBF,0xAD,0x20,0x20,0x20,0x20,0x20,0x20,0xBA,0xAF,0xBC,0xF6,0xBF,0xA1,0x20,0xC0,0xFA,0xC0,0xE5,0xB5,0xC7,0xB4,0xC2,0x20,0xC0,0xCF,0xB7,0xC3,0xC0,0xC7,0x20,0xB9,0xAE,0xC0,0xDA,0xB5,0xE9,0xC0,0xBB,0x20,0xC1,0xF6,0xC1,0xA4,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xCC,0x20,0xBB,0xE7,0xBF,0xEB,0xC7,0xCF,0xB8,0xE9,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xBC,0xB3,0xC1,0xA4,0xB5,0xC8,0x20,0xC8,0xAF,0xB0,0xE6,0xBA,0xAF,0xBC,0xF6,0xB8,0xA6,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,0x00
};

/*
Displays the name of or changes the current directory.

CHDIR [drive:][path]
CHDIR[..]
CD [drive:][path]
CD[..]

  ..   Specifies that you want to change to the parent directory.

Type CD drive: to display the current directory in the specified drive.
Type CD without parameters to display the current drive and directory.
*/
const BYTE help_chdir_korean[] = {
	0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xB8,0xA6,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xD6,0xB0,0xC5,0xB3,0xAA,0x20,0xBA,0xAF,0xB0,0xE6,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x20,0x5B,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x5D,0x5B,0xB0,0xE6,0xB7,0xCE,0x5D,0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x43,0x44,0x20,0x5B,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x5D,0x5B,0xB0,0xE6,0xB7,0xCE,0x5D,0x0D,0x0A,
	0x43,0x44,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0x2E,0x2E,0x20,0x20,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xC0,0xC7,0x20,0xBB,0xF3,0xC0,0xA7,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xB7,0xCE,0x20,0xC0,0xCC,0xB5,0xBF,0xC7,0xD5,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x43,0x44,0x20,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x20,0xB8,0xA6,0x20,0xC0,0xD4,0xB7,0xC2,0xC7,0xCF,0xB8,0xE9,0x20,0xC1,0xF6,0xC1,0xA4,0xC7,0xD1,0x20,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0xC0,0xC7,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xB8,0xA6,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x43,0x44,0x20,0xB8,0xED,0xB7,0xC9,0xC0,0xBB,0x20,0xB8,0xC5,0xB0,0xB3,0xBA,0xAF,0xBC,0xF6,0x20,0xBE,0xF8,0xC0,0xCC,0x20,0xBB,0xE7,0xBF,0xEB,0xC7,0xCF,0xB8,0xE9,0x20,0xC7,0xF6,0xC0,0xE7,0x20,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0xBF,0xCD,0x20,0xB5,0xF0,0xB7,0xBA,0xC5,0xCD,0xB8,0xAE,0xB8,0xA6,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,0x00
};

/*
Displays the contents of text files.

TYPE [drive:][path]filename
*/
const BYTE help_type_korean[] = {
	0xC5,0xD8,0xBD,0xBA,0xC6,0xAE,0x20,0xC6,0xC4,0xC0,0xCF,0xC0,0xC7,0x20,0xB3,0xBB,0xBF,0xEB,0xC0,0xBB,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x59,0x50,0x45,0x20,0x5B,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x5D,0x5B,0xB0,0xE6,0xB7,0xCE,0x5D,0xC6,0xC4,0xC0,0xCF,0x0D,0x0A,0x00
};

/*
Displays the MS-DOS Version.

VER
*/
const BYTE help_ver_korean[] = {
	0xC7,0xD1,0xB1,0xDB,0x20,0x4D,0x53,0x2D,0x44,0x4F,0x53,0x20,0xB9,0xF6,0xC0,0xFC,0xC0,0xBB,0x20,0xBA,0xB8,0xBF,0xA9,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x56,0x45,0x52,0x0D,0x0A,0x00
};

/*
Returns a fully qualified filename.

TRUENAME [drive:][path]filename
*/
const BYTE help_truename_korean[] = {
	0xBF,0xCF,0xC0,0xFC,0xC7,0xD1,0xC6,0xC4,0xC0,0xCF,0xB8,0xED,0xC0,0xBB,0xB5,0xB9,0xB7,0xC1,0xC1,0xDD,0xB4,0xCF,0xB4,0xD9,0x2E,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x52,0x55,0x45,0x4E,0x41,0x4D,0x45,0x20,0x5B,0xB5,0xE5,0xB6,0xF3,0xC0,0xCC,0xBA,0xEA,0x3A,0x5D,0x5B,0xB0,0xE6,0xB7,0xCE,0x5D,0xC6,0xC4,0xC0,0xCF,0xB8,0xED,0x0D,0x0A,0x00
};

#endif
