/*
	MS-DOS Player for Win32 console

	Author : Takeda.Toshiya
	Date   : 2024.07.14-
*/

#ifndef _LANG_TW_H_
#define _LANG_TW_H_

/* ----------------------------------------------------------------------------
	Traditional Chinese messages (950: Big5)
---------------------------------------------------------------------------- */

// Invalid function
const BYTE standard_error_taiwanese_01[] = {0xA5,0x5C,0xAF,0xE0,0xB5,0x4C,0xAE,0xC4,0x00};
// File not found
const BYTE standard_error_taiwanese_02[] = {0xC0,0xC9,0xAE,0xD7,0xA7,0xE4,0xA4,0xA3,0xA8,0xEC,0x00};
// Path not found
const BYTE standard_error_taiwanese_03[] = {0xB8,0xF4,0xAE,0x7C,0xA7,0xE4,0xA4,0xA3,0xA8,0xEC,0x00};
// Too many open files
const BYTE standard_error_taiwanese_04[] = {0xB6,0x7D,0xB1,0xD2,0xAA,0xBA,0xC0,0xC9,0xAE,0xD7,0xBC,0xC6,0xA5,0xD8,0xB9,0x4C,0xA6,0x68,0x00};
// Access denied
const BYTE standard_error_taiwanese_05[] = {0xA4,0xA3,0xAF,0xE0,0xA6,0x73,0xA8,0xFA,0x00};
// Invalid handle
const BYTE standard_error_taiwanese_06[] = {0xC0,0xC9,0xAE,0xD7,0xB3,0x42,0xB2,0x7A,0xBD,0x73,0xB8,0xB9,0xB5,0x4C,0xAE,0xC4,0x00};
// Memory control blocks destroyed
const BYTE standard_error_taiwanese_07[] = {0xB0,0x4F,0xBE,0xD0,0xC5,0xE9,0xB1,0xB1,0xA8,0xEE,0xB0,0xCF,0xB6,0xF4,0xB7,0x6C,0xC3,0x61,0xA4,0x46,0x00};
// Insufficient memory
const BYTE standard_error_taiwanese_08[] = {0xB0,0x4F,0xBE,0xD0,0xC5,0xE9,0xA4,0xA3,0xB0,0xF7,0x00};
// Invalid memory block address
const BYTE standard_error_taiwanese_09[] = {0xB0,0x4F,0xBE,0xD0,0xC5,0xE9,0xB0,0xCF,0xB6,0xF4,0xA6,0xEC,0xA7,0x7D,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid Environment
const BYTE standard_error_taiwanese_0A[] = {0xC0,0xF4,0xB9,0xD2,0xAA,0xBA,0xAB,0xFC,0xA9,0x77,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid format
const BYTE standard_error_taiwanese_0B[] = {0xAE,0xE6,0xA6,0xA1,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid function parameter
const BYTE standard_error_taiwanese_0C[] = {0xA5,0x5C,0xAF,0xE0,0xAA,0xBA,0xB0,0xD1,0xBC,0xC6,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid data
const BYTE standard_error_taiwanese_0D[] = {0xB8,0xEA,0xAE,0xC6,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid drive specification
const BYTE standard_error_taiwanese_0F[] = {0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0xAA,0xBA,0xAB,0xFC,0xA9,0x77,0xB5,0x4C,0xAE,0xC4,0x00};
// Attempt to remove current directory
const BYTE standard_error_taiwanese_10[] = {0xA5,0xF8,0xB9,0xCF,0xA7,0x52,0xB0,0xA3,0xB2,0x7B,0xA6,0xE6,0xA5,0xD8,0xBF,0xFD,0x00};
// Not same device
const BYTE standard_error_taiwanese_11[] = {0xAB,0xFC,0xA9,0x77,0xA4,0x46,0xA4,0xA3,0xA6,0x50,0xAA,0xBA,0xB8,0xCB,0xB8,0x6D,0x00};
// No more files
const BYTE standard_error_taiwanese_12[] = {0xB5,0x4C,0xAA,0x6B,0xA6,0x41,0xB6,0x7D,0xB1,0xD2,0xC0,0xC9,0xAE,0xD7,0x00};

// Write protect error
const BYTE critical_error_taiwanese_00[] = {0xA8,0xBE,0xBD,0x64,0xBC,0x67,0xA4,0x4A,0xBF,0xF9,0xBB,0x7E,0x00};
// Invalid unit
const BYTE critical_error_taiwanese_01[] = {0xB8,0xCB,0xB8,0x6D,0xB5,0x4C,0xAE,0xC4,0x00};
// Not ready
const BYTE critical_error_taiwanese_02[] = {0xA9,0x7C,0xA5,0xBC,0xB7,0xC7,0xB3,0xC6,0xB4,0x4E,0xBA,0xFC,0x00};
// Invalid device request
const BYTE critical_error_taiwanese_03[] = {0xB8,0xCB,0xB8,0x6D,0xAD,0x6E,0xA8,0x44,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Data error
const BYTE critical_error_taiwanese_04[] = {0xB8,0xEA,0xAE,0xC6,0xBF,0xF9,0xBB,0x7E,0x00};
// Invalid device request parameters
const BYTE critical_error_taiwanese_05[] = {0xB8,0xCB,0xB8,0x6D,0xAD,0x6E,0xA8,0x44,0xB0,0xD1,0xBC,0xC6,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Seek error
const BYTE critical_error_taiwanese_06[] = {0xB7,0x6A,0xB4,0x4D,0xBF,0xF9,0xBB,0x7E,0x00};
// Invalid media type
const BYTE critical_error_taiwanese_07[] = {0xB4,0x43,0xC5,0xE9,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Sector not found
const BYTE critical_error_taiwanese_08[] = {0xBA,0xCF,0xB0,0xCF,0xA7,0xE4,0xA4,0xA3,0xA8,0xEC,0x00};
// Printer out of paper error
const BYTE critical_error_taiwanese_09[] = {0xA6,0x4C,0xAA,0xED,0xBE,0xF7,0xAA,0xBA,0xB3,0xF8,0xAA,0xED,0xAF,0xC8,0xA5,0xCE,0xBA,0xC9,0x00};
// Write fault error
const BYTE critical_error_taiwanese_0A[] = {0xBC,0x67,0xA4,0x4A,0xBF,0xF9,0xBB,0x7E,0x00};
// Read fault error
const BYTE critical_error_taiwanese_0B[] = {0xC5,0xAA,0xA8,0xFA,0xBF,0xF9,0xBB,0x7E,0x00};
// General failure
const BYTE critical_error_taiwanese_0C[] = {0xA4,0x40,0xAF,0xEB,0xA9,0xCA,0xBF,0xF9,0xBB,0x7E,0x00};
// Sharing violation
const BYTE critical_error_taiwanese_0D[] = {0xB9,0x48,0xA4,0xCF,0xC0,0xC9,0xAE,0xD7,0xA6,0x40,0xA5,0xCE,0x00};
// Lock violation
const BYTE critical_error_taiwanese_0E[] = {0xB9,0x48,0xA4,0xCF,0xC2,0xEA,0xA9,0x77,0x00};
// Invalid disk change
const BYTE critical_error_taiwanese_0F[] = {0xBA,0xCF,0xBA,0xD0,0xA7,0xF3,0xB4,0xAB,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// FCB unavailable
const BYTE critical_error_taiwanese_10[] = {0x46,0x43,0x42,0x20,0xA4,0xA3,0xA6,0x73,0xA6,0x62,0x00};
// System resource exhausted
const BYTE critical_error_taiwanese_11[] = {0xA8,0x74,0xB2,0xCE,0xB8,0xEA,0xB7,0xBD,0xA4,0x77,0xB3,0xE0,0xA5,0xA2,0x00};
// Code page mismatch
const BYTE critical_error_taiwanese_12[] = {0xA6,0x72,0xBD,0x58,0xAD,0xB6,0xA4,0xA3,0xA6,0x58,0x00};
// Out of input
const BYTE critical_error_taiwanese_13[] = {0xBF,0xE9,0xA4,0x4A,0xB8,0xEA,0xAE,0xC6,0xA4,0xA3,0xA8,0xAC,0x00};
// Insufficient disk space
const BYTE critical_error_taiwanese_14[] = {0xBA,0xCF,0xBA,0xD0,0xAA,0xC5,0xB6,0xA1,0xA4,0xA3,0xB0,0xF7,0x00};

// File exists
const BYTE standard_error_taiwanese_50[] = {0xC0,0xC9,0xAE,0xD7,0xA6,0x73,0xA6,0x62,0x00};
// Cannot make directory entry
const BYTE standard_error_taiwanese_52[] = {0xB5,0x4C,0xAA,0x6B,0xAB,0xD8,0xB3,0x79,0xB3,0x6F,0xAD,0xD3,0xA5,0xD8,0xBF,0xFD,0xB6,0xB5,0xA5,0xD8,0x00};
// Fail on INT 24
const BYTE standard_error_taiwanese_53[] = {0x49,0x4E,0x54,0x20,0x32,0x34,0x20,0xA4,0xA4,0xB5,0x6F,0xA5,0xCD,0xBF,0xF9,0xBB,0x7E,0x00};
// Too many redirections
const BYTE standard_error_taiwanese_54[] = {0xAD,0xAB,0xB7,0x73,0xAB,0xFC,0xA6,0x56,0xAB,0xFC,0xA9,0x77,0xB9,0x4C,0xA6,0x68,0x00};
// Duplicate redirection
const BYTE standard_error_taiwanese_55[] = {0xAD,0xAB,0xB7,0x73,0xAB,0xFC,0xA6,0x56,0xAB,0xFC,0xA9,0x77,0xAD,0xAB,0xBD,0xC6,0x00};
// Invalid password
const BYTE standard_error_taiwanese_56[] = {0xB3,0x71,0xA6,0xE6,0xBD,0x58,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid parameter
const BYTE standard_error_taiwanese_57[] = {0xB0,0xD1,0xBC,0xC6,0xB5,0x4C,0xAE,0xC4,0x00};
// Network data fault
const BYTE standard_error_taiwanese_58[] = {0xBA,0xF4,0xB8,0xF4,0xAA,0xBA,0xB8,0xEA,0xAE,0xC6,0xBF,0xF9,0xBB,0x7E,0x00};
// Function not supported by network
const BYTE standard_error_taiwanese_59[] = {0xBA,0xF4,0xB8,0xF4,0xA5,0xBC,0xA4,0xE4,0xB4,0xA9,0xAA,0xBA,0xA5,0x5C,0xAF,0xE0,0x00};
// Required system component not installed
const BYTE standard_error_taiwanese_5A[] = {0xA5,0xBC,0xBE,0xC9,0xA4,0x4A,0xA5,0xB2,0xAD,0x6E,0xAA,0xBA,0xA8,0x74,0xB2,0xCE,0xAD,0x6E,0xAF,0xC0,0x00};

// Unknown error
const BYTE standard_error_taiwanese_64[] = {0xA5,0xBC,0xAA,0xBE,0xBF,0xF9,0xBB,0x7E,0x00};
// Not ready
const BYTE standard_error_taiwanese_65[] = {0xA9,0x7C,0xA5,0xBC,0xB7,0xC7,0xB3,0xC6,0xB4,0x4E,0xBA,0xFC,0x00};
// EMS memory no longer valid
const BYTE standard_error_taiwanese_66[] = {0x45,0x4D,0x53,0x20,0xB0,0x4F,0xBE,0xD0,0xC5,0xE9,0xA4,0xA3,0xA6,0x41,0xA6,0xB3,0xAE,0xC4,0x00};
// CDROM not High Sierra or ISO-9660 format
const BYTE standard_error_taiwanese_67[] = {0x43,0x44,0x52,0x4F,0x4D,0x20,0xA4,0xA3,0xAC,0x4F,0x20,0x48,0x69,0x67,0x68,0x20,0x53,0x69,0x65,0x72,0x72,0x61,0x20,0xA9,0xCE,0x20,0x49,0x53,0x4F,0x2D,0x39,0x36,0x36,0x30,0x20,0xAE,0xE6,0xA6,0xA1,0x00};
// Door open
const BYTE standard_error_taiwanese_68[] = {0xB1,0xB1,0xA8,0xEE,0xB1,0xEC,0xA5,0xBC,0xC3,0xF6,0xB3,0xAC,0x00};

// Volume is not locked
const BYTE standard_error_taiwanese_B0[] = {0xAE,0x65,0xC5,0xE9,0xA5,0xBC,0xC2,0xEA,0xA9,0x77,0x00};
// Volume is locked in drive
const BYTE standard_error_taiwanese_B1[] = {0xAE,0x65,0xC5,0xE9,0xA4,0x77,0xC2,0xEA,0xA9,0x77,0x00};
// Volume is not removable
const BYTE standard_error_taiwanese_B2[] = {0xAE,0x65,0xC5,0xE9,0xA4,0xA3,0xA5,0x69,0xB2,0xBE,0xB0,0xA3,0x00};
// Lock count has been exceeded
const BYTE standard_error_taiwanese_B4[] = {0xAE,0x65,0xC5,0xE9,0xB5,0x4C,0xAA,0x6B,0xA6,0x41,0xB3,0x51,0xC2,0xEA,0xA9,0x77,0x00};
// A valid eject request failed
const BYTE standard_error_taiwanese_B5[] = {0xB5,0x4C,0xAA,0x6B,0xBC,0x75,0xA5,0x58,0xAE,0x65,0xC5,0xE9,0x00};

// Too many parameters
const BYTE param_error_taiwanese_01[] = {0xB0,0xD1,0xBC,0xC6,0xB9,0x4C,0xA6,0x68,0x00};
// Required parameter missing
const BYTE param_error_taiwanese_02[] = {0xA8,0x53,0xA6,0xB3,0xA5,0xB2,0xAD,0x6E,0xAA,0xBA,0xB0,0xD1,0xBC,0xC6,0x00};
// Invalid switch
const BYTE param_error_taiwanese_03[] = {0xA4,0xC1,0xB4,0xAB,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid keyword
const BYTE param_error_taiwanese_04[] = {0xC3,0xF6,0xC1,0xE4,0xA6,0x72,0xB5,0x4C,0xAE,0xC4,0x00};
// Parameter value not in allowed range
const BYTE param_error_taiwanese_06[] = {0xB0,0xD1,0xBC,0xC6,0xAA,0xBA,0xAD,0xC8,0xA4,0xA3,0xA6,0x62,0xAE,0x65,0xB3,0x5C,0xBD,0x64,0xB3,0xF2,0xA4,0xA4,0x00};
// Parameter value not allowed
const BYTE param_error_taiwanese_07[] = {0xB0,0xD1,0xBC,0xC6,0xAA,0xBA,0xAD,0xC8,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Parameter value not allowed
const BYTE param_error_taiwanese_08[] = {0xB0,0xD1,0xBC,0xC6,0xAA,0xBA,0xAD,0xC8,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Parameter format not correct
const BYTE param_error_taiwanese_09[] = {0xB0,0xD1,0xBC,0xC6,0xAA,0xBA,0xAE,0xE6,0xA6,0xA1,0xA4,0xA3,0xA5,0xBF,0xBD,0x54,0x00};
// Invalid parameter
const BYTE param_error_taiwanese_0A[] = {0xB0,0xD1,0xBC,0xC6,0xB5,0x4C,0xAE,0xC4,0x00};
// Invalid parameter combination
const BYTE param_error_taiwanese_0B[] = {0xB0,0xD1,0xBC,0xC6,0xAA,0xBA,0xB2,0xD5,0xA6,0x58,0xB5,0x4C,0xAE,0xC4,0x00};

// Unknown error
const BYTE unknown_error_taiwanese[] = {0xA5,0xBC,0xAA,0xBE,0xBF,0xF9,0xBB,0x7E,0x00};
// Critical error
const BYTE critical_error_taiwanese[] = {0xC4,0x59,0xAD,0xAB,0xBF,0xF9,0xBB,0x7E,0x00};

// writing drive
const BYTE writing_drive_taiwanese[] = {0xB5,0x6F,0xA5,0xCD,0xA9,0xF3,0xBC,0x67,0xA4,0x4A,0x20,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x00};
// reading drive
const BYTE reading_drive_taiwanese[] = {0xB5,0x6F,0xA5,0xCD,0xA9,0xF3,0xC5,0xAA,0xA8,0xFA,0x20,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x00};

// Abort (A)
const BYTE abort_taiwanese[] = {0xB0,0xB1,0xA4,0xEE,0xB0,0xF5,0xA6,0xE6,0x20,0x28,0x41,0x29,0x00};
// Retry (R)
const BYTE retry_taiwanese[] = {0xA6,0x41,0xB8,0xD5,0xA4,0x40,0xA6,0xB8,0x20,0x28,0x52,0x29,0x00};
// Igore (I)
const BYTE ignore_taiwanese[] = {0xB1,0x6A,0xA8,0xEE,0xB0,0xF5,0xA6,0xE6,0x20,0x28,0x49,0x29,0x00};
// Fail (F)
const BYTE fail_taiwanese[] = {0xA5,0xA2,0xB1,0xD1,0x20,0x28,0x46,0x29,0x00};

/*
Displays or sets a search path for executable files.

PATH [[drive:]path[;...]]
PATH ;

Type PATH ; to clear all search-path settings and direct MS-DOS to search
only in the current directory.
Type PATH without parameters to display the current path.
*/
const BYTE help_path_taiwanese[] = {
	0xC5,0xE3,0xA5,0xDC,0xA1,0xFE,0xB3,0x5D,0xA9,0x77,0xA5,0x69,0xB0,0xF5,0xA6,0xE6,0xC0,0xC9,0xAE,0xD7,0xAA,0xBA,0xB7,0x6A,0xB4,0x4D,0xB8,0xF4,0xAE,0x7C,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x5B,0x5B,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x5D,0xB8,0xF4,0xAE,0x7C,0x5B,0x3B,0x2E,0x2E,0x2E,0x5D,0x5D,0x0D,0x0A,
	0x50,0x41,0x54,0x48,0x20,0x3B,0x0D,0x0A,
	0x0D,0x0A,
	0xB6,0xC8,0xAB,0xFC,0xA9,0x77,0xA4,0xC0,0xB8,0xB9,0xA7,0x40,0xAC,0xB0,0xB0,0xD1,0xBC,0xC6,0x28,0x22,0x50,0x41,0x54,0x48,0x20,0x3B,0x22,0x29,0xAE,0xC9,0xA1,0x41,0xB7,0x7C,0xB2,0x4D,0xB0,0xA3,0xA9,0xD2,0xA6,0xB3,0xAA,0xBA,0xB7,0x6A,0xB4,0x4D,0xB8,0xF4,0xAE,0x7C,0xA1,0x41,0x0D,0x0A,
	0x4D,0x53,0x2D,0x44,0x4F,0x53,0x20,0xB6,0xC8,0xB7,0x6A,0xB4,0x4D,0xB2,0x7B,0xA6,0xE6,0xA5,0xD8,0xBF,0xFD,0xA1,0x43,0x0D,0x0A,
0xAD,0x59,0xA5,0xBC,0xAB,0xFC,0xA9,0x77,0xB0,0xD1,0xBC,0xC6,0xA1,0x41,0xAB,0x68,0xB7,0x7C,0xC5,0xE3,0xA5,0xDC,0xB2,0x7B,0xA6,0xE6,0xB8,0xF4,0xAE,0x7C,0xA1,0x43,0x0D,0x0A,0x00
};

/*
Displays, sets, or removes MS-DOS environment variables.

SET [variable=[string]]

  variable  Specifies the environment-variable name.
  string    Specifies a series of characters to assign to the variable.

Type SET without parameters to display the current environment variables.
*/
const BYTE help_set_taiwanese[] = {
	0xC5,0xE3,0xA5,0xDC,0xA1,0xFE,0xB3,0x5D,0xA9,0x77,0xA9,0xCE,0xA7,0x52,0xB0,0xA3,0x20,0x4D,0x53,0x2D,0x44,0x4F,0x53,0x20,0xC0,0xF4,0xB9,0xD2,0xC5,0xDC,0xBC,0xC6,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x53,0x45,0x54,0x20,0x5B,0xC5,0xDC,0xBC,0xC6,0xA6,0x57,0xBA,0xD9,0x3D,0x5B,0xA6,0x72,0xA6,0xEA,0x5D,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0xC5,0xDC,0xBC,0xC6,0xA6,0x57,0x20,0x20,0x20,0x20,0xAB,0xFC,0xA9,0x77,0xC0,0xF4,0xB9,0xD2,0xC5,0xDC,0xBC,0xC6,0xAA,0xBA,0xA6,0x57,0xBA,0xD9,0xA1,0x43,0x0D,0x0A,
	0x20,0x20,0xA6,0x72,0xA6,0xEA,0x20,0x20,0x20,0x20,0x20,0x20,0xAB,0xFC,0xA9,0x77,0xAD,0x6E,0xAB,0xFC,0xAC,0xA3,0xB5,0xB9,0xC5,0xDC,0xBC,0xC6,0xAA,0xBA,0xA6,0x72,0xA6,0xEA,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0xA6,0x70,0xAA,0x47,0xA8,0x53,0xA6,0xB3,0xAB,0xFC,0xA9,0x77,0xB0,0xD1,0xBC,0xC6,0xA1,0x41,0xAB,0x68,0xC5,0xE3,0xA5,0xDC,0xA5,0xD8,0xAB,0x65,0xC0,0xF4,0xB9,0xD2,0xC5,0xDC,0xBC,0xC6,0xA1,0x43,0x0D,0x0A,0x00
};

/*
Displays the name of or changes the current directory.

CHDIR [drive:][path]
CHDIR[..]
CD [drive:][path]
CD[..]

  ..   Specifies that you want to change to the parent directory.

Type CD drive: to display the current directory in the specified drive.
Type CD without parameters to display the current drive and directory.
*/
const BYTE help_chdir_taiwanese[] = {
	0xC5,0xE3,0xA5,0xDC,0xA1,0xFE,0xC5,0xDC,0xA7,0xF3,0xB2,0x7B,0xA6,0xE6,0xA5,0xD8,0xBF,0xFD,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x20,0x5B,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x5D,0x5B,0xB8,0xF4,0xAE,0x7C,0x5D,0x0D,0x0A,
	0x43,0x48,0x44,0x49,0x52,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x43,0x44,0x20,0x5B,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x5D,0x5B,0xB8,0xF4,0xAE,0x7C,0x5D,0x0D,0x0A,
	0x43,0x44,0x5B,0x2E,0x2E,0x5D,0x0D,0x0A,
	0x0D,0x0A,
	0x20,0x20,0x2E,0x2E,0x20,0x20,0x20,0xB1,0xFD,0xC5,0xDC,0xA7,0xF3,0xAC,0xB0,0xA5,0xC0,0xA5,0xD8,0xBF,0xFD,0xAE,0xC9,0xAB,0xFC,0xA9,0x77,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0xBF,0xE9,0xA4,0x4A,0x20,0x43,0x44,0x20,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x20,0xAE,0xC9,0xA1,0x41,0xB7,0x7C,0xC5,0xE3,0xA5,0xDC,0xAB,0xFC,0xA9,0x77,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0xAA,0xBA,0xB2,0x7B,0xA6,0xE6,0xA5,0xD8,0xBF,0xFD,0xA1,0x43,0x0D,0x0A,
	0xAD,0x59,0xA5,0xBC,0xAB,0xFC,0xA9,0x77,0xB0,0xD1,0xBC,0xC6,0xA1,0x41,0xAB,0x68,0xB7,0x7C,0xC5,0xE3,0xA5,0xDC,0xB2,0x7B,0xA6,0xE6,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0xBB,0x50,0xB2,0x7B,0xA6,0xE6,0xA5,0xD8,0xBF,0xFD,0xA1,0x43,0x0D,0x0A,0x00
};

/*
Displays the contents of text files.

TYPE [drive:][path]filename
*/
const BYTE help_type_taiwanese[] = {
	0xC5,0xE3,0xA5,0xDC,0xA5,0xBB,0xA4,0xE5,0xC0,0xC9,0xAE,0xD7,0xAA,0xBA,0xA4,0xBA,0xAE,0x65,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x59,0x50,0x45,0x20,0x5B,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x5D,0x5B,0xB8,0xF4,0xAE,0x7C,0x5D,0xC0,0xC9,0xAE,0xD7,0xA6,0x57,0xBA,0xD9,0x0D,0x0A,0x00
};

/*
Displays the MS-DOS Version.

VER
*/
const BYTE help_ver_taiwanese[] = {
	0xC5,0xE3,0xA5,0xDC,0x20,0x44,0x4F,0x53,0x20,0xAA,0xBA,0xAA,0xA9,0xA5,0xBB,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x56,0x45,0x52,0x0D,0x0A,0x00
};

/*
Returns a fully qualified filename.

TRUENAME [drive:][path]filename
*/
const BYTE help_truename_taiwanese[] = {
	0xB6,0xC7,0xA6,0x5E,0xA7,0xB9,0xBE,0xE3,0xAA,0xBA,0xC0,0xC9,0xAE,0xD7,0xA6,0x57,0xBA,0xD9,0xA1,0x43,0x0D,0x0A,
	0x0D,0x0A,
	0x54,0x52,0x55,0x45,0x4E,0x41,0x4D,0x45,0x20,0x5B,0xBA,0xCF,0xBA,0xD0,0xBE,0xF7,0x3A,0x5D,0x5B,0xB8,0xF4,0xAE,0x7C,0x5D,0xC0,0xC9,0xAE,0xD7,0xA6,0x57,0xBA,0xD9,0x0D,0x0A,0x00
};

#endif
